texture	g_tex0;
float	g_power;
float	g_pan;

const float topy = 0.1302083f;
const float bottomy = 0.8697916f;
const float rgbi = 0.00392156f;

const float onepx = 0.0013020833f;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
	Texture = (g_tex0);
    MIPFILTER	= LINEAR;
    MAGFILTER	= LINEAR;
    MINFILTER	= LINEAR;
    AddressU	= BORDER;
    AddressV	= BORDER;
};


struct vs_params
{ 
     float4 position 	: POSITION0;
     float2 tex		: TEXCOORD0;
};


//VERTEX SHADER
void vs( in vs_params IN, out vs_params OUT ) 
{
	OUT.position = IN.position;
	
	OUT.tex = IN.tex;
}

//PIXEL SHADER
float4 ps( float2 tex : TEXCOORD0 ) : COLOR
{
	float4 result;

	int pan = g_pan * 100;

	if( tex.y < onepx * pan || tex.y > onepx * (768 - pan))
		result = float4(0, 0, 0, 1);
	else
	{
		float3 TextureColor = tex2D( tex0 , tex ).xyz;
		float bw = (TextureColor.x + TextureColor.y + TextureColor.z) * 0.33333f;
		bw *= 4.0f;

		float3 sepiatone = lerp(float3(1, 1, 1), float3(0.43921568f, 0.25882352f, 0.07843137f), g_pan) * bw;

		result = float4( sepiatone, 1.0f) + g_power;
	}

	return result;
}

technique Default
{
    pass P0
    {
		//cullmode = none;
        VertexShader	= compile vs_3_0 vs();
        PixelShader		= compile ps_2_0 ps();
    }
}